/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.images.command;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public abstract class BaseCommand {
    private int min;
    private final String name;
    private String desc = "";
    private String usage;
    private final String permission;
    private String[] aliases = new String[0];
    private final Map<String, BaseCommand> children = new HashMap<String, BaseCommand>();

    protected BaseCommand(String name, String permission) {
        this.name = name;
        this.usage = '/' + name;
        this.permission = permission;
    }

    public abstract void execute(Player var1, String var2, String[] var3);

    public void execute(CommandSender sender, String label, String[] args) {
        sender.sendMessage("Sorry, /" + this.name + " is player only.");
    }

    public boolean hasPermission(CommandSender sender, String[] args) {
        return sender.hasPermission(this.permission);
    }

    public void tabComplete(CommandSender sender, String[] args, List<String> completions) {
        String first = args[0].toLowerCase();
        if (first.isEmpty()) {
            completions.add(sender.getName());
            return;
        }
        Player player = Bukkit.getPlayer((String)first);
        if (player == null) {
            Bukkit.getOnlinePlayers().forEach(pl -> {
                if (sender instanceof Player && !((Player)sender).canSee(pl)) {
                    return;
                }
                String name = pl.getName();
                if (name.toLowerCase().startsWith(first)) {
                    completions.add(name);
                }
            });
        } else {
            completions.add(player.getName());
        }
    }

    Map<String, BaseCommand> getChildren() {
        return this.children;
    }

    protected void addChild(BaseCommand child) {
        Preconditions.checkNotNull((Object)child);
        this.children.put(child.getName().toLowerCase(), child);
        for (String alias : child.getAliases()) {
            this.children.put(alias.toLowerCase(), child);
        }
    }

    protected void setMinimumArgs(int min) {
        this.min = min;
    }

    protected void setAliases(String ... aliases) {
        this.aliases = aliases;
    }

    protected void setDesc(String desc) {
        this.desc = desc;
    }

    protected void setUsage(String usage) {
        this.usage = usage.replace("<command>", this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getUsage() {
        return this.usage;
    }

    public int getMinimumArgs() {
        return this.min;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCommand)) {
            return false;
        }
        BaseCommand cmd = (BaseCommand)o;
        if (cmd.getName().equalsIgnoreCase(this.name)) {
            return true;
        }
        for (String alias : cmd.getAliases()) {
            if (alias.equalsIgnoreCase(this.name)) {
                return true;
            }
            for (String alias1 : this.getAliases()) {
                if (!alias.equalsIgnoreCase(alias1)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + Arrays.hashCode(this.aliases) * 17;
    }

    public String toString() {
        return this.name;
    }
}

